\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{habilitacije}[2024/06/05 Vloge za habilitacije na FMF]

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% NALAGANJE PAKETOV
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\LoadClass[12pt,a4paper]{article}

\RequirePackage[T1]{fontenc}
\RequirePackage[utf8x]{inputenc}
\RequirePackage{etoolbox}
\RequirePackage{keyval}
\RequirePackage[raggedright,small,nobottomtitles]{titlesec}
\RequirePackage{enumitem}

\titleformat{\subsection}{\normalfont\bfseries\normalsize}{\thesubsection}{1em}{}

\titleformat{\subsubsection}{\normalfont\bfseries\small}{\thesubsubsection}{1em}{}

\newlist{dokazila}{enumerate}{1}
\setlist[dokazila]{nosep,label={\arabic*.}}

\newlist{casovnica}{description}{1}
\setlist[casovnica]{style=nextline,leftmargin=2.5cm,font=\normalfont}

\newlist{izobrazba}{description}{1}
\setlist[izobrazba]{style=nextline,leftmargin=2.5cm,font=\bfseries}

\RequirePackage{xurl} % break long URLs
\RequirePackage[table]{xcolor}
\RequirePackage[colorlinks]{hyperref}
\urlstyle{same} % use the same font for URLs as for the text
\hypersetup{allcolors=blue} % all links are blue

\RequirePackage[slovene]{babel}
\RequirePackage{times}
\RequirePackage{amsmath,amsfonts,amssymb}
\RequirePackage[margin=1in]{geometry}
\RequirePackage{booktabs}
\RequirePackage{longtable}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% OPCIJE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\DeclareOption{prva}{
  \def\@kateraIzvolitev{izvolitev}
  \def\@kateroIzvolitev{izvolitev}
  \def\@jePonovnaIzvolitev{}
  \def\@standardnePriloge{%
    \item Predstavitev kandidata ob vlogi v izvolitev v naziv
    \item Pregled dela in točkovnik
    \item Klasificirana bibliografija
    \item Seznam potencialnih tujih poročevalcev
    \item Predstavitev kandidata v angleščini
  }
}

\DeclareOption{ponovna}{
  \def\@kateraIzvolitev{ponovna izvolitev}
  \def\@kateroIzvolitev{ponovno izvolitev}
  \def\@jePonovnaIzvolitev{(ponovna)}
  \def\@standardnePriloge{%
    \item Predstavitev kandidata ob vlogi v izvolitev v naziv
    \item Pregled dela in točkovnik
    \item Klasificirana bibliografija
  }
}

\DeclareOption{docent}{
  \def\@habilitacijskiNaziv{docent}
}
\DeclareOption{izredni}{
  \def\@habilitacijskiNaziv{izredni profesor}
}
\DeclareOption{redni}{
  \def\@habilitacijskiNaziv{redni profesor}
  \def\@kateraIzvolitev{izvolitev}
  \def\@kateroIzvolitev{izvolitev}
  \def\@jePonovnaIzvolitev{}
  \def\@standardnePriloge{%
    \item Predstavitev kandidata ob vlogi v izvolitev v naziv
    \item Pregled dela in točkovnik
    \item Klasificirana bibliografija
    \item Seznam potencialnih tujih poročevalcev
    \item Predstavitev kandidata v angleščini
  }
}

% \DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}

\ProcessOptions\relax

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% VNOS METAPODATKOV
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand{\@definefield}[2]{
  % \definefield{@imepolja}{...} načeloma naredi \def\@imepolja{...},
  % le da pri tem iz ... pobriše presledke
  % Iz imena ukaza dobimo ukaz s pomočjo \csname kot
  %   \csname imeukaza\endcsname ~> \imeukaza
  % Če bi napisali \def\csname @imepolja\endcsname{...} bi to povozilo ukaz
  % \csname, zato moramo uporabiti \expandafter, da najprej izvedemo \csname,
  % šele nato \def.
  \expandafter\def\csname #1\endcsname{\ifblank{#2}{}{#2}}
}

\newcommand{\datumMerila}{\@definefield{@datumMerila}}
\newcommand{\seznamDokazil}{\@definefield{@seznamDokazil}}
\newcommand{\polnoIme}{\@definefield{@polnoIme}}
\newcommand{\kontaktniNaslov}{\@definefield{@kontaktniNaslov}}
\newcommand{\habilitacijskoPodrocje}{\@definefield{@habilitacijskoPodrocje}}
\newcommand{\datumVloge}{\@definefield{@datumVloge}}
\newcommand{\datumRojstva}{\@definefield{@datumRojstva}}
\newcommand{\krajRojstva}{\@definefield{@krajRojstva}}
\newcommand{\drzavljanstvo}{\@definefield{@drzavljanstvo}}
\newcommand{\email}{\@definefield{@email}}

\define@key{citati}{poLetih}{\def\@citatiPoLetih{#1}}
\define@key{citati}{skupni}{\def\@citatiSkupni{#1}}
\newcommand{\citati}[2][WoS]{
  \setkeys{citati}{#2}
  \begin{description}
    \item[Čisti citati po letih (#1):] \@citatiPoLetih.
    \item[Skupaj:] \@citatiSkupni
  \end{description}
}

\newenvironment{vodenjeProjektov}{
  \subsection*{Vodenje projektov}
  \begingroup
    \def\arraystretch{1.5}
    \small
    \begin{longtable}{
     >{\raggedright\arraybackslash}p{0.3\textwidth}
     >{\raggedright\arraybackslash}p{0.25\textwidth}
     >{\raggedright\arraybackslash}p{0.2\textwidth}
     >{\raggedright\arraybackslash}p{0.15\textwidth}
  }
  \toprule
  \textbf{Projekt} & \textbf{Obdobje} & \textbf{Financer} & \textbf{Obseg financiranja} \\
  \midrule \endhead
}
{
  \bottomrule
  \end{longtable}\endgroup
}

\newenvironment{sodelovanjePriProjektih}{
  \subsection*{Sodelovanje pri projektih}
  \begingroup
  \def\arraystretch{1.5}
  \small
  \begin{longtable}{
     >{\raggedright\arraybackslash}p{0.3\textwidth}
     >{\raggedright\arraybackslash}p{0.25\textwidth}
     >{\raggedright\arraybackslash}p{0.2\textwidth}
     >{\raggedright\arraybackslash}p{0.15\textwidth}
  }
  \toprule
  \textbf{Projekt} & \textbf{Obdobje}  & \textbf{Vloga} & \textbf{Financer} \\
  \midrule \endhead
}{
  \bottomrule
  \end{longtable}\endgroup
}

\newenvironment{kolicinskiPogoji}{
  \section{Izpolnjevanje minimalnih količinskih in kakovostnih pogojev\\
  (\@kateraIzvolitev\ v naziv \@habilitacijskiNaziv, \@habilitacijskoPodrocje)}
  \subsection{Količinski pogoji}
  \begingroup
  \footnotesize
  \def\arraystretch{1.5}
  \begin{longtable}{
    >{\raggedright\arraybackslash}p{0.33\textwidth}
    >{\raggedright\arraybackslash}p{0.2\textwidth}
    >{\raggedright\arraybackslash}p{0.15\textwidth}
    >{\raggedright\arraybackslash}p{0.15\textwidth}
  }
  \toprule
  \textbf{Pogoj} & \textbf{Enote} & \textbf{Zahtevano} & \textbf{Doseženo}\\
  \midrule \endhead
}{
  \bottomrule
  \end{longtable}\endgroup
}
\newcommand{\podpogoj}[1]{{}\hfill\parbox[t]{0.27\textwidth}{\raggedright\arraybackslash #1}\vspace{1ex}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% KAKOVOSTNI POGOJI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newenvironment{kakovostniPogoji}{
  \subsection{Kakovostni pogoji (matematika)}
  \begingroup
  \def\arraystretch{1.5}
  \begin{longtable}{
    p{0.4\textwidth}
    p{0.2\textwidth}
    p{0.2\textwidth}
  }
  \toprule
  \textbf{Pogoj} & \textbf{Samoocena} & \textbf{Utemeljitev} \\
  \midrule \endhead
}{
  \bottomrule
  \end{longtable}\endgroup
}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% IZPIS ZAČETNIH STRANI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\AfterEndPreamble{%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% KROVNO PISMO
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\thispagestyle{empty}
\newgeometry{margin=1.5in}

\noindent
\@polnoIme

\noindent
\@kontaktniNaslov

\vspace{1cm}

\noindent
Fakulteta za matematiko in fiziko

\noindent
Univerza v Ljubljani

\noindent
Jadranska 19

\noindent
1000 Ljubljana

\noindent
\hfill\@datumVloge

\bigskip\bigskip

\noindent
{\bf Prošnja za \@kateroIzvolitev\ v naziv \@habilitacijskiNaziv}

\bigskip

\noindent
Prosim za \@kateroIzvolitev\ v naziv \@habilitacijskiNaziv\ za področje \@habilitacijskoPodrocje\ po Merilih za volitve v nazive visokošolskih učiteljev, znanstvenih delavcev ter sodelavcev Univerze v Ljubljani z dne \@datumMerila\ z nadaljnjimi spremembami.
%
Prošnji prilagam zahtevano dokumentacijo.

\smallskip

Izjavljam, da so točni vsi podatki, ki jih navajam v predstavitvi kandidata, pregledu dela, točkovniku, bibliografiji in v priloženih dokazilih. Izjavljam, da z nobenim od navedenih potencialnih poročevalcev nimam navzkrižja interesov.

\vspace{4\baselineskip}
\hfill\@polnoIme\hspace{1in}\hbox{}

\vfill


\noindent
Priloge:
%
\begin{itemize}[noitemsep]
\@standardnePriloge
\item Ostala dokazila
  %
  \@seznamDokazil
\end{itemize}

\newpage
\restoregeometry

\noindent
{\large\bf Predstavitev kandidata ob vlogi za izvolitev v naziv}

%\bigskip

\begin{description}[style=sameline,leftmargin=4.5cm,font=\normalfont]
  \item[Zaprošeni~naziv:] \textbf{\@habilitacijskiNaziv\ \@jePonovnaIzvolitev}
  \item[Habilitacijsko področje:] \textbf{\@habilitacijskoPodrocje}
\end{description}

%\bigskip

\section{Osnovni podatki o kandidatu}

\begin{description}[style=sameline,leftmargin=4.5cm,font=\normalfont]
  \item[Ime in priimek:] \@polnoIme
  \item[Datum in kraj rojstva:] \@datumRojstva, \@krajRojstva
  \item[Državljanstvo:] \@drzavljanstvo
\end{description}
 
\section{Kontaktni podatki}

\begin{description}[style=sameline,leftmargin=4.5cm,font=\normalfont]
  \item[Naslov:] \parbox[t]{0.3\textwidth}{\@kontaktniNaslov}
  \item[E-pošta:] \href{mailto:@email}{\texttt{\@email}}
\end{description}
}%AfterEndPreamble
